% fcst_gamma_mean_V1.m
% 
% Forecast gamma shares using cosine transformations ... 
%       Linear trend + I(1) model
% 
% "The Past and Future of U.S. Structural Change" 
% Andrew Foerster, Andreas Hornstein, Pierre-Daniel Sarte, Mark Watson
% September 2025
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 
function fcst_gamma_mean_V1()

% -- File Directories -- %
% datadir = 'Data/DataReplication/DataFinal/'; 
% outdir = 'Tables/';
% figdir = 'Figures/';
% matdir = 'Output/';

% -- Load Data and Setup -- %
gamma = [];             % this prevents an error from confusion about gamma
load_data
% n_draws = 5000;
period_lower = 20;       % Shortest Period 
T_is = size(theta,1);
q_is = floor(2*T/period_lower);
per_q_is = 2*T/q_is;
fprintf('Number of cosine transformations for in-sample period: %d\n',q_is);
fprintf('Number of Shortest Periods: %5.1f \n',per_q_is);

Ydata = gamma;

% Construct Forecasts ... univariate ... one for each entry ... note that these are between zero and 1, so impose this constraint
i_base = 2;
for i = 1:size(Ydata,2)
    Share_mat = [Ydata(:,i) 1-Ydata(:,i)];
    X_is = logit_s_to_x(Share_mat,i_base);
    Y = X_is(:,1:end ~= i_base);
    % Get some results from I_1 model
    I_1 = 1;     % Levels data are I(1)
    I_trend = 1; % Include linear trend in the projections
    h_os = T_is;
    [Yproj_is_i, Yproj_os_mean_i, trend_os_only_i] = fcst_y_trend_mean(Y,q_is,h_os,I_1,I_trend);
    T_os = size(Yproj_is_i,1);
    % Get LF estimates of Shares
    Share_is = [Share_mat;NaN(T_os-T_is,size(Share_mat,2))];
    Shareproj_is = logit_y_to_s(Yproj_is_i,i_base);
    Shareproj_os_mean = logit_y_to_s(Yproj_os_mean_i,i_base);
    Share_os_trend_only = logit_y_to_s(trend_os_only_i,i_base);
    if i == 1
        Y_is = Share_is(:,1);
        Yproj_is = Shareproj_is(:,1);
        Yproj_os_mean = Shareproj_os_mean(:,1);
        trend_os_only = Share_os_trend_only(:,1);
    else
        Y_is = [Y_is Share_is(:,1)]; %#ok<*AGROW>
        Yproj_is = [Yproj_is Shareproj_is(:,1)];
        Yproj_os_mean = [Yproj_os_mean Shareproj_os_mean(:,1)];
        trend_os_only = [trend_os_only Share_os_trend_only(:,1)];
    end
end

% Add the trend-only Forecast
Y_os_trend = NaN(size(Yproj_os_mean));
Y_os_trend(T_is+1:end,:) = Yproj_os_mean(T_is,:)+trend_os_only(T_is+1:end,:)-trend_os_only(T_is,:); %#ok<NASGU>

save_variables = {'Y_is','Yproj_os_mean','Yproj_is','Y_os_trend','trend_os_only'};
save([matdir 'fcst_gamma_V1_' num2str(q_is) '.mat'],save_variables{:});

